unit FileListBox;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.IO;

type
  TFileListBox = class(System.Windows.Forms.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    ListBox1: System.Windows.Forms.ListBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  {$REGION 'Prywatne pola i metody'}
  strict private
  	//pola wewnetrzne
		listaKatalogow :array of String;
		listaPlikow :array of String;
		listaDyskow :array of String;
		pokazujDwieKropki :Boolean;
		//pola przechowujace ustawienia komponentu
		sciezkaKatalogu :String;
		uwzglednijKatalogi :Boolean;
		uwzglednijPliki :Boolean;
		uwzglednijDyski :Boolean;
		uwzglednijKatalogNadrzedny :Boolean;
		filtr :String;
    //metody
    procedure PobierzZawartoscKatalogu;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFileListBox))]

implementation

uses
  System.Globalization;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFileListBox.InitializeComponent;
begin
  Self.ListBox1 := System.Windows.Forms.ListBox.Create;
  Self.SuspendLayout;
  // 
  // ListBox1
  // 
  Self.ListBox1.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListBox1.HorizontalScrollbar := True;
  Self.ListBox1.ItemHeight := 16;
  Self.ListBox1.Location := System.Drawing.Point.Create(0, 0);
  Self.ListBox1.Name := 'ListBox1';
  Self.ListBox1.Size := System.Drawing.Size.Create(376, 340);
  Self.ListBox1.TabIndex := 0;
  // 
  // TFileListBox
  // 
  Self.Controls.Add(Self.ListBox1);
  Self.Name := 'TFileListBox';
  Self.Size := System.Drawing.Size.Create(376, 344);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

constructor TFileListBox.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;

  //inicjacja prywatnych pol klasy
	pokazujDwieKropki:=True;
	sciezkaKatalogu:=nil;
	uwzglednijKatalogi:=True;
	uwzglednijPliki:=True;
	uwzglednijDyski:=True;
	uwzglednijKatalogNadrzedny:=True;
	filtr:=nil;

  //zapelnianie listy
  PobierzZawartoscKatalogu;
end;

procedure TFileListBox.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

procedure TFileListBox.PobierzZawartoscKatalogu;
type TablicaObiektow = array of TObject;
var i :Integer;
begin
if sciezkaKatalogu=nil then sciezkaKatalogu:=Directory.GetCurrentDirectory;

pokazujDwieKropki:=(sciezkaKatalogu<>Path.GetPathRoot(sciezkaKatalogu))
                   and uwzglednijKatalogNadrzedny;

if (not Directory.Exists(sciezkaKatalogu)) then
		raise Exception.Create('Katalog '+sciezkaKatalogu+' nie istnieje!');

ListBox1.Items.Clear;

if uwzglednijKatalogi then
		begin
		if pokazujDwieKropki then ListBox1.Items.Add('[..]');
		listaKatalogow:=Directory.GetDirectories(sciezkaKatalogu);
  	for i:=0 to Length(listaKatalogow)-1 do
    	listBox1.Items.Add('['+Path.GetFileName(listaKatalogow[i])+']');
		end;
if uwzglednijPliki then
		begin
    if (filtr<>nil) then
      listaPlikow:=Directory.GetFiles(sciezkaKatalogu,filtr)
      else
      listaPlikow:=Directory.GetFiles(sciezkaKatalogu);
    for i:=0 to Length(listaPlikow)-1 do
    	listBox1.Items.Add(Path.GetFileName(listaPlikow[i]));
		end;
if uwzglednijDyski then
		begin
		listaDyskow:=Directory.GetLogicalDrives();
		for i:=0 to Length(listaDyskow)-1 do
	    listBox1.Items.Add('<'+listaDyskow[i].Substring(0,2)+'>');
		end;
end;

end.
